<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Oficina de Bienestar Universitario de la Universidad Nacional de San Martin - UNSM">
    <meta name="keywords" content="UNSM, Bienestar Universitario, Universidad San Martin, OBU">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Bienestar Universitario - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Bienestar Universitario -->
    <link rel="stylesheet" href="css/styleBienUni.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en Facebook" aria-label="Pagina oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Siguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Siguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Telefono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0159</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la pagina principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martin" width="auto" height="70">
                </a>
            </div>

            <!-- Boton Hamburguesa para movil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menu de navegacion" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegacion principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menu Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Mision y Vision</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Academico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menu Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Academico</a></li>
                                <li><a href="../../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigacion</a></li>
                                <li><a href="../../../oficinas/secretaria general/indexSecreGene.php">Secretaria General</a></li>
                                <li><a href="../../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicacion e Imagen Institucional</a></li>
                                <li><a href="../../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperacion y Relaciones Internacionales</a></li>
                                <li><a href="../../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Organo de Control Institucional</a></li>
                                <li><a href="../../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoria Juridica</a></li>
                                <li><a href="../../../oficinas/Grados y Titulos/indexGrados.php">Grados y Titulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Academicas</li>
                                <li><a href="../OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admision</a></li>
                                <li><a href="../ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Academicos</a></li>
                                <li><a href="../Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Insercion Laboral</a></li>
                                <li><a href="../TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologias de la Informacion</a></li>
                                <li><a href="../INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="../FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comite Electoral Universitario</a></li>
                                <li><a href="../INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovacion y Transferencia Tecnologica</a></li>
                                <li><a href="../PRODUCCION DE BIENES Y SERVICIOS/indexProdu.php">Produccion de Bienes y Servicios</a></li>
                                <li><a href="../RESPONSABILIDAD SOCIAL UNIVERSITARIA/indexRespon.php">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../SERVICIOS GENERALES/indexServiGe.php">Servicios Generales</a></li>
                                <li><a href="indexBienUni.php">Bienestar Universitario</a></li>
                                <li><a href="../../../#defensoria">Defensoria Universitaria</a></li>
                                <li><a href="../../../#calidad">Gestion de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">ADMISION</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menu Facultades">
                            <li class="has-submenu">
                                <a href="../../../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../../#agronomia">Agronomia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingenieria Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Agroindustrial">
                                    <li><a href="../../../#ing-agroindustrial">Ingenieria Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingenieria Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Civil y Arquitectura">
                                    <li><a href="../../../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../../#ingenieria-civil-carrera">Ingenieria Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingenieria de Sistemas e Informatica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria de Sistemas">
                                    <li><a href="../../../#ing-sistemas">Ingenieria de Sistemas e Informatica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ecologia" aria-haspopup="true" aria-expanded="false">Ecologia</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecologia">
                                    <li><a href="../../../#ing-ambiental">Ingenieria Ambiental</a></li>
                                    <li><a href="../../../#ing-sanitaria">Ingenieria Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Politicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../../#enfermeria">Enfermeria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Economicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Economicas">
                                    <li><a href="../../../#administracion">Administracion</a></li>
                                    <li><a href="../../../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../../#economia">Economia</a></li>
                                    <li><a href="../../../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../../#educacion" aria-haspopup="true" aria-expanded="false">Educacion y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educacion">
                                    <li><a href="../../../#educacion-inicial">Educacion Inicial</a></li>
                                    <li><a href="../../../#educacion-primaria">Educacion Primaria</a></li>
                                    <li><a href="../../../#educacion-secundaria">Educacion Secundaria</a></li>
                                    <li><a href="../../../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../../#psicologia">
                                            Psicologia
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Menu Transparencia">
                            <li><a href="#licenciamiento">Licenciamiento</a></li>
                            <li><a href="#institucional">Institucional Ley 30220</a></li>
                            <li><a href="#estandar">Estandar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Peru">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Peru">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Bienestar Universitario -->
    <section class="comite-banner">
        <div class="banner-container">
            <h1>BIENESTAR UNIVERSITARIO</h1>
            <div class="banner-contact">
                <p><strong>Local Central, Jr. Maynas N° 177, Tarapoto, Peru</strong></p>
                <p>obu@unsm.edu.pe</p>
            </div>
        </div>
    </section>

    <!-- Contenido Principal -->
    <main class="comite-main">
        <div class="comite-container">
            <!-- Sidebar con tabs -->
            <aside class="comite-sidebar">
                <nav class="tabs-menu">
                    <button class="tab-button active" data-tab="funciones">
                        <span class="tab-icon">&#9881;</span>
                        <span class="tab-text">FUNCIONES</span>
                    </button>
                    <button class="tab-button" data-tab="mision">
                        <span class="tab-icon">&#127919;</span>
                        <span class="tab-text">MISION</span>
                    </button>
                    <button class="tab-button" data-tab="vision">
                        <span class="tab-icon">&#128065;</span>
                        <span class="tab-text">VISION</span>
                    </button>
                    <button class="tab-button" data-tab="servicios">
                        <span class="tab-icon">&#128188;</span>
                        <span class="tab-text">SERVICIOS UNIVERSITARIOS</span>
                    </button>
                    <button class="tab-button" data-tab="personal">
                        <span class="tab-icon">&#128100;</span>
                        <span class="tab-text">PERSONAL</span>
                    </button>
                    <button class="tab-button" data-tab="documentos">
                        <span class="tab-icon">&#128195;</span>
                        <span class="tab-text">DOCUMENTOS</span>
                    </button>
                    <button class="tab-button" data-tab="reglamentos">
                        <span class="tab-icon">&#128214;</span>
                        <span class="tab-text">REGLAMENTOS</span>
                    </button>
                </nav>
            </aside>

            <!-- Contenido principal -->
            <div class="comite-content">
                <!-- Tab de Funciones -->
                <div class="tab-content active" id="funciones">
                    <div class="content-wrapper">
                        <h2>FUNCIONES</h2>

                        <ul class="funciones-list">
                            <li>Cumplir y hacer cumplir la Ley, Estatuto, el presente Reglamento, Reglamento de Organizacion y Funciones, Manual de Organizacion y Funciones, Texto Unico de Procedimientos Administrativos de la UNSM-T y demas disposiciones.</li>

                            <li>Conducir la formulacion y ejecucion del Plan Operativo Institucional y Presupuesto Anual, asi como los lineamientos y/o directivas que contribuyan al cambio organizacional.</li>

                            <li>Crear e implementar un sistema de base de datos, calendario de becas, convocatorias y promocion de la accion social.</li>

                            <li>Implementar las actividades de cultura, deporte y recreacion.</li>

                            <li>Formular y ejecutar programas de atencion y prevencion de la salud en medicina general, odontologia, psicologia, laboratorio clinico, etc.</li>

                            <li>Dirigir, coordinar, supervisar y evaluar las actividades del Comedor Universitario y de los Servicios Asistenciales.</li>

                            <li>Elaborar y proponer lineamientos de politica en Bienestar Universitario.</li>

                            <li>Dirigir y participar en la elaboracion del Plan-Trabajo Anual.</li>

                            <li>Realizar visitas de inspeccion inopinadas al Comedor Universitario y los Servicios Asistenciales.</li>

                            <li>Administrar los fondos de la cuenta autogente del estudiante, en coordinacion con el correspondiente Reglamento y la politica de Bienestar Universitario.</li>

                            <li>Proponer y/o reformular, conjuntamente que los de la Oficina y responsables de areas.</li>

                            <li>Supervisar y verificar la recepcion de los alimentos, diversos, conforme a los documentos de adquisicion.</li>

                            <li>Supervisar la buena conservacion de alimentos y otros suministros en los almacenes del Comedor y las demas funciones que le asigne la Alta Direccion.</li>

                            <li>Proponer los lineamientos de politica de bienestar, deporte y cultura en la UNSM-T, alineados a los objetivos estrategicos y estrategias de la UNSM-T.</li>

                            <li>Formular su Plan Anual de Funcionamiento y Desarrollo y su Memoria Anual, de acuerdo a las directrices emitidas para el caso.</li>

                            <li>Responder de los diferentes tipos de problemas que puedan aquejar a la comunidad universitaria (especialmente a los estudiantes) y ejercer labor asistencial.</li>

                            <li>Organizar y supervisar los servicios de asistencia en salud, deporte, comedor y recreacion.</li>

                            <li>Organizar el seguro de salud estudiantil.</li>

                            <li>Canalizar toda la documentacion de las Unidades Tecnicas con el resto de organos de la UNSM-T, asi oficiar se genera flujo de informacion y las disposiciones emitidas como simplificacion administrativa y modernizacion de la gestion publica.</li>

                            <li>Elaborar, aprobar, distribuir y verificar el cumplimiento de normas internas y directivas dentro del ambito de sus competencias y funciones asignadas por el presente Reglamento y el Estatuto.</li>

                            <li>Realizar funciones inherentes al nivel y naturaleza de la Oficina de Bienestar Universitario, dentro del marco de lo normado en el Estatuto y el presente Reglamento.</li>

                            <li>Coordinar con las Facultades, Institutos, Escuelas y Oficinas de la Universidad, las becas, semi becas, ayudantias, bolsa de trabajo y otras formas de ayuda a los estudiantes.</li>
                        </ul>
                    </div>

                    <!-- Widget de Agenda Rector -->
                    <aside class="noticias-widget">
                        <h3>Agenda Rector</h3>
                        <div class="noticias-container">
                            <p class="no-events">No hay nuevos eventos.</p>
                            <div class="calendario-actions">
                                <a href="#" class="btn-calendar">Ver Calendario &#9656;</a>
                            </div>
                        </div>
                    </aside>
                </div>

                <!-- Tab de Mision -->
                <div class="tab-content" id="mision">
                    <div class="content-wrapper">
                        <h2>MISION</h2>
                        <p>Somos la unidad encargada de promover y garantizar el bienestar integral de la comunidad universitaria, brindando servicios de salud, alimentacion, asistencia social, deporte, cultura y recreacion, contribuyendo a la formacion integral de los estudiantes y al mejoramiento de la calidad de vida de todos los miembros de la universidad.</p>
                    </div>
                </div>

                <!-- Tab de Vision -->
                <div class="tab-content" id="vision">
                    <div class="content-wrapper">
                        <h2>VISION</h2>
                        <p>Ser una oficina reconocida por la excelencia en la prestacion de servicios de bienestar universitario, promoviendo el desarrollo integral de la comunidad universitaria mediante programas innovadores de salud, alimentacion, asistencia social, deporte y cultura, en un ambiente de calidad y calidez humana.</p>
                    </div>
                </div>

                <!-- Tab de Servicios Universitarios -->
                <div class="tab-content" id="servicios">
                    <div class="content-wrapper">
                        <h2>SERVICIOS UNIVERSITARIOS</h2>
                        <p>La Oficina de Bienestar Universitario ofrece los siguientes servicios a la comunidad universitaria:</p>

                        <ul class="funciones-list">
                            <li><strong>Servicio de Salud:</strong> Atencion medica general, odontologia, psicologia y laboratorio clinico para estudiantes, docentes y personal administrativo.</li>
                            <li><strong>Comedor Universitario:</strong> Servicio de alimentacion balanceada y nutritiva a precios accesibles para la comunidad universitaria.</li>
                            <li><strong>Asistencia Social:</strong> Programas de becas, semi becas, ayudantias y bolsa de trabajo para estudiantes con necesidades economicas.</li>
                            <li><strong>Deportes:</strong> Organizacion de actividades deportivas, torneos y competencias para fomentar la practica del deporte.</li>
                            <li><strong>Cultura y Recreacion:</strong> Talleres artisticos, eventos culturales y actividades recreativas para el desarrollo integral.</li>
                            <li><strong>Seguro Estudiantil:</strong> Gestion del seguro de salud para estudiantes matriculados.</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Personal -->
                <div class="tab-content" id="personal">
                    <div class="content-wrapper">
                        <h2>PERSONAL</h2>
                        <p>La Oficina de Bienestar Universitario de la UNSM cuenta con un equipo multidisciplinario de profesionales comprometidos con el bienestar de la comunidad universitaria.</p>
                        <p>Informacion sobre el personal de la oficina estara disponible proximamente.</p>
                    </div>
                </div>

                <!-- Tab de Documentos -->
                <div class="tab-content" id="documentos">
                    <div class="content-wrapper">
                        <h2>DOCUMENTOS</h2>
                        <p>En esta seccion encontrara los documentos oficiales relacionados con Bienestar Universitario:</p>
                        <ul class="funciones-list">
                            <li><strong>Plan Operativo Institucional:</strong> Documento de planificacion anual de la oficina</li>
                            <li><strong>Memoria Anual:</strong> Informe de actividades y logros del periodo</li>
                            <li><strong>Formatos de Solicitud:</strong> Documentos para tramites de becas, servicios de salud y comedor</li>
                            <li><strong>Directivas:</strong> Normas internas de la oficina</li>
                        </ul>
                    </div>
                </div>

                <!-- Tab de Reglamentos -->
                <div class="tab-content" id="reglamentos">
                    <div class="content-wrapper">
                        <h2>REGLAMENTOS</h2>
                        <p>Documentos normativos que rigen las actividades de Bienestar Universitario:</p>
                        <ul class="funciones-list">
                            <li><strong>Reglamento de Bienestar Universitario:</strong> Normas generales que regulan los servicios de bienestar</li>
                            <li><strong>Reglamento del Comedor Universitario:</strong> Disposiciones para el funcionamiento del comedor</li>
                            <li><strong>Reglamento de Becas y Ayudas Economicas:</strong> Criterios y procedimientos para otorgamiento de becas</li>
                            <li><strong>Reglamento de Actividades Deportivas:</strong> Normas para la organizacion de actividades deportivas</li>
                            <li><strong>Reglamento de Seguro Estudiantil:</strong> Disposiciones sobre el seguro de salud estudiantil</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autonomo y de caracter estatal, comprometido con la formacion de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N° 177 - Morales</p>
                    <p>Tarapoto - San Martin - Peru</p>
                    <p>Central Telefonica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rapidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../#admision">Admision</a></li>
                    <li><a href="../../../#facultades">Facultades</a></li>
                    <li><a href="../../../#posgrado">Posgrado</a></li>
                    <li><a href="../../../#investigacion">Investigacion</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="#campus-virtual">Campus Virtual</a></li>
                    <li><a href="#repositorio">Repositorio Institucional</a></li>
                    <li><a href="#transparencia">Portal de Transparencia</a></li>
                    <li><a href="#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <!-- Plugin de Facebook -->
                <?php include 'plugin/meta.html'; ?>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martin. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Siguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="../../../js/script.js"></script>
    <script src="js/bienestarUni.js"></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
